/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp2;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp2.Demand;
import cz.insophy.inplan.mrp2.PropertyTransferer;
import cz.insophy.inplan.mrp2.SortKeyExtractor;
import cz.insophy.inplan.shop.Material;
import javax.annotation.Nonnull;

public class CrDemand
implements Demand {
    private final CustomerRequest cr;

    public CrDemand(@Nonnull CustomerRequest cr) {
        this.cr = Preconditions.checkNotNull(cr);
    }

    @Nonnull
    public CustomerRequest getCr() {
        return this.cr;
    }

    @Override
    @Nonnull
    public <T> T extractProperties(@Nonnull PropertyTransferer<T> transferer) {
        return transferer.getProperties(this.cr);
    }

    @Override
    @Nonnull
    public Material getMaterial() {
        return this.cr.getMaterial();
    }

    @Override
    public double getQty() {
        return this.cr.getQty();
    }

    @Override
    @Nonnull
    public <T extends Comparable<T>> T getSortKey(@Nonnull SortKeyExtractor<T> sortKeyExtractor) {
        return sortKeyExtractor.extract(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("cr", this.cr).toString();
    }
}

